<?php
// Database connection
require 'koneksi.php';
require 'header2.php';

$sesi = $_SESSION['level'];
if ($sesi == "") {
    header("location: login.php");
    exit;
}

// If the submit button is clicked, add data to the database
if (isset($_POST["submit"])) {
    $name = $_POST["nama"];
    $views = $_POST["views"];
    $subscribers = $_POST["subscribers"];
    $frequency = $_POST["frekuensi"];
    $videos = $_POST["videos"];
    $background = $_POST["background"];

    $query = "INSERT INTO channel (nama, views, subscribers, frekuensi, videos, background) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);

    if ($stmt === false) {
        die("Query failed: " . mysqli_error($conn));
    }

    $stmt->bind_param("ssssss", $name, $views, $subscribers, $frequency, $videos, $background);

    if ($stmt->execute()) {
        echo "<script>
            alert('Channel data successfully added!');
            window.location = 'tambah_channel.php';
        </script>";
    } else {
        echo "<script>
            alert('Data failed to add! " . mysqli_error($conn) . "');
        </script>";
    }

    $stmt->close();
}

// If the delete button is clicked
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];

    if (!empty($id) && is_numeric($id)) {
        $query = "DELETE FROM channel WHERE id = ?";
        $stmt = $conn->prepare($query);

        if ($stmt === false) {
            die("Query failed: " . mysqli_error($conn));
        }

        $stmt->bind_param("i", $id);

        if ($stmt->execute()) {
            echo "<script>
                alert('Data successfully deleted!');
                window.location = 'tambah_channel.php';
            </script>";
        } else {
            echo "<script>
                alert('Failed to delete data! " . mysqli_error($conn) . "');
            </script>";
        }

        $stmt->close();
    }
}
?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid py-4">
        <div class="d-flex justify-content-center mb-4">
            <h2 class="mb-0 text-center">Add YouTube Channel Data Form</h2>
        </div>

            <!-- Add Channel Form -->
                <div class="card-body">
                    <form action="" method="post">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label><b>Channel Name</b></label>
                                <input type="text" name="nama" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label><b>Number of Views</b></label>
                                <input type="text" name="views" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label><b>Number of Subscribers</b></label>
                                <input type="text" name="subscribers" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label><b>Video Upload Frequency</b></label>
                                <input type="text" name="frekuensi" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label><b>Number of Uploaded Videos</b></label>
                                <input type="text" name="videos" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label><b>Content Creator Background</b></label>
                                <textarea name="background" class="form-control" rows="2" required></textarea>
                            </div>
                        </div>
                        <div class="text-center">
                            <button class="btn btn-success btn-lg" type="submit" name="submit">
                                <i class="fas fa-plus"></i> Add Data
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Channel List Table -->
            <h3 class="mb-3">YouTube Channel List</h3>
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead class="table-success text-center align-middle">
                        <tr>
                            <th>No</th>
                            <th>Channel Name</th>
                            <th>Number of Views</th>
                            <th>Number of Subscribers</th>
                            <th>Video Upload Frequency</th>
                            <th>Number of Videos</th>
                            <th>Background</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $result = mysqli_query($conn, "SELECT * FROM channel ORDER BY id ASC");
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)) :
                        ?>
                            <tr style="height: 50px;">
                                <td class="align-middle text-center"><?= $no++; ?></td>
                                <td class="align-middle"><?= htmlspecialchars($row['nama']); ?></td>
                                <td class="align-middle text-center"><?= htmlspecialchars($row['views']); ?></td>
                                <td class="align-middle text-center"><?= htmlspecialchars($row['subscribers']); ?></td>
                                <td class="align-middle text-center"><?= htmlspecialchars($row['frekuensi']); ?></td>
                                <td class="align-middle text-center"><?= htmlspecialchars($row['videos']); ?></td>
                                <td class="align-middle" style="text-align: justify;"><?= htmlspecialchars($row['background']); ?></td>
                                <td class="align-middle text-center">
                                    <div class="d-flex justify-content-center gap-2">
                                        <a href="ubah_channel.php?id=<?= $row['id']; ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <a href="tambah_channel.php?hapus=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete?');">
                                            <i class="fas fa-trash-alt"></i> Delete
                                        </a>
                                    </div>
                                </td>

                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>
